/**
 * Internet Connection Status Checker (ICSC)
 *
 * written by Matthias Muenzner <jkaref@matthias-muenzner.com>
 *
 * (c) 2008 by [j]karef GmbH Berlin.
 */

var connectionStatus = false;
var userLanguage     = '';

/**
 *
 */
function init() 
{
	if (userLanguage == '') {
		var lang = '';
		if (navigator.appName.indexOf('Internet Explorer') > -1) {
			lang = navigator.browserLanguage;
		} else {
			lang = navigator.language;
		}
			
		if ((lang.indexOf('cn') > -1) || (lang.indexOf('zh') > -1)) {
			userLanguage = 'cn';
		} else if (lang.indexOf('es') > -1) {
			userLanguage = 'es';
		} else if (lang.indexOf('de') > -1) {
			userLanguage = 'de';
		} else if (lang.indexOf("en") > -1) {
			userLanguage = 'en';
		} else if (lang.indexOf("fr" > -1)) {
			userLanguage = 'en';
		} else {
			userLanguage = 'en';
		}
	}
	return true;
}

/**
 * set language
 */
function setLanguage(__lang) 
{
	userLanguage = __lang;
	
	if (connectionStatus == true)
		onConnectionExist();
	else 
		onConnectionError();
	return true;
}

/**
 * connection exist event handler 
 */
function onConnectionExist()
{
	connectionStatus = true;
	init();
	var iframeElement = window.document.getElementById('iframe_content');
	iframeElement.style.visibility = "visible";
	iframeElement.style.display = "inline";
	iframeElement.style.minHeight = "800px";
	var flashElement = window.document.getElementById('EnigmaSpaceFlight');
	flashElement.style.visibility = 'visible';
	flashElement.style.display = 'inline';
	getInfo();
	return true;
}

/**
 * connection error event handler  
 */
function onConnectionError() 
{
	connectionStatus = false;
	init();
	var flashElement = window.document.getElementById('EnigmaSpaceFlight');
	flashElement.style.visibility = 'hidden';
	flashElement.style.display = 'none';
	var flashContainer = window.document.getElementById('enigma_space_flight_display');
	flashContainer.style.visibility = 'hidden';
	flashContainer.style.display = 'none';
	var iframeElement = window.document.getElementById('iframe_content');
	iframeElement.style.visibility = "visible";
	iframeElement.style.display = "inline";
	getRegistration();
	return true;
}

/**
 * get info page
 */
function getInfo()
{
	var infoDocPath = '';
	
	switch (userLanguage) {
		case 'en': {
			infoDocPath = 'html/info.en.html';
			break;
		}
		case 'de': {
			infoDocPath = 'html/info.de.html';
			break;
		}
		case 'es': {
			infoDocPath = 'html/info.es.html';
			break;
		}
		case 'cn': {
			infoDocPath = 'html/info.cn.html';
			break;
		}
		case 'fr': {
			infoDocPath = 'html/info.en.html';
			break;
		}
		default: {
			infoDocPath = 'html/info.en.html';
			break;
		}
	}
	
	var elem = document.getElementById('iframe_content');
	elem.src = infoDocPath;
	
	// wait a little time then forward to www.enigmaspace.com
//	elem.visibility = 'hidden';
//	elem.display = 'none';
	
}

/**
 * get registration form
 */
function getRegistration()
{
    var infoDocPath = '';
    
    
    switch (userLanguage) {
        case 'en': {
            infoDocPath = 'html/register.en.html';
            break;
        }
        case 'de': {
            infoDocPath = 'html/register.de.html';
            break;
        }
        case 'es': {
            infoDocPath = 'html/register.es.html';
            break;
        }
        case 'cn': {
            infoDocPath = 'html/register.cn.html';
            break;
        }
        case 'fr': {
        	infoDocPath = 'html/register.en.html';
        	break;
        }
        default: {
            infoDocPath = 'html/register.en.html';
            break;
        }
    }
    
    var elem = document.getElementById('iframe_content');
    elem.src = infoDocPath;
    
    return true;
}
